<?php
/**
 * Archives template.
 *
 * @package Avada
 * @subpackage Templates
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<?php get_header(); ?>
<section id="content" class="<?php esc_attr_e( apply_filters( 'awb_content_tag_class', '' ) ); // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText ?>" style="<?php esc_attr_e( apply_filters( 'awb_content_tag_style', '' ) ); // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText ?>">
	<?php if ( category_description() ) : ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class( 'fusion-archive-description' ); ?>>
			<div class="post-content">
				<?php echo category_description(); ?>
			</div>
		</div>
	<?php endif; ?>

	<?php get_template_part( 'templates/blog', 'layout' ); ?>
</section>
<?php do_action( 'avada_after_content' ); ?>
<?php get_footer(); ?>
